'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kategorien", acSaveYes
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'alle Eingabefelder sperren
    Me.Jahresauswahl.Enabled = False
    Me.Kunden_alle.Enabled = False
    Me.Kunden_nur.Enabled = False
    Me.Kundenauswahl.Enabled = False
    Me.Kunden_direkt.Enabled = False
    Me.START_Button.Enabled = False
End Sub

Private Sub Kunden_direkt_GotFocus()
    Me.Kundenauswahl.DefaultValue = 1
End Sub

Private Sub Kunden_direkt_LostFocus()
    If IsNull(Me.Kunden_direkt.Value) Then Me.Kundenauswahl.DefaultValue = 0
End Sub

Private Sub Kunden_nur_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kunden_direkt.SetFocus
End Sub

Private Sub START_Button_Click()
On Error GoTo Err_START_Button_Click

    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim strAbfrage As String
    
    'Datenbankumgebung festlegen
    Set dbs = CurrentDb
    
    
    BerichteFilter = ""

    'je nach Bericht: Eingaben prfen und Bericht aufrufen
    Select Case Me.Suchfeld.Value
        Case 1                  'Rechnungsbuch
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 2                  'Rechnungssummen nach Kunden
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 3                  'Terminliste eines Kunden
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
            'Kundenauswahl prfen
            If IsNull(Me.Kunden_direkt.Value) Or (Me.Kunden_direkt.Value = 0) Or (Me.Kunden_direkt.Value = "") Then
                MsgBox "Bitte whlen Sie einen Kunden aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Kunden_direkt.SetFocus
                Exit Sub
            End If
        Case 4                  'Rechnungsliste eines Kunden
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
            'Kundenauswahl prfen
            If IsNull(Me.Kunden_direkt.Value) Or (Me.Kunden_direkt.Value = 0) Or (Me.Kunden_direkt.Value = "") Then
                MsgBox "Bitte whlen Sie einen Kunden aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Kunden_direkt.SetFocus
                Exit Sub
            End If
        Case 5                  'Aktualisierungen
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 6                  'Gebhrenliste eines Kunden
            'Kundenauswahl prfen
            If IsNull(Me.Kunden_direkt.Value) Or (Me.Kunden_direkt.Value = 0) Or (Me.Kunden_direkt.Value = "") Then
                MsgBox "Bitte whlen Sie einen Kunden aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Kunden_direkt.SetFocus
                Exit Sub
            End If
        Case 7                  'Umsatzverteilung
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 8                  'Zeitverteilung
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 9                  'Umsatzverteilung mit Zeitaufwand
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 10                 'Zeitverteilung mit Umsatzanteil
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 11                 'Erfolgsverteilung
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 12                 'Rechnungslufe
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 13                 'Datenbankzuordnungen
            'keine weiteren Eingaben erforderlich
        Case 14                 'Versionshistorie
            'keine weiteren Eingaben erforderlich
        Case 15                 'Reisekilometer
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 16                 'Zeitverteilung mit Reisekilometer
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 17                 'Zeitverteilung im Jahr
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 18                 'Umsatzverteilung im Jahr
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 19                 'Kategorieverteilung
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 20                 'Kategorien: Kalkulationsverteilung je Jahr
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 21                 'Kategorien: Kalkulationsverteilung mit Zeitanteil
            'Jahresauswahl prfen
            If IsNull(Me.Jahresauswahl.Value) Or (Me.Jahresauswahl.Value = 0) Or (Me.Jahresauswahl.Value = "") Then
                MsgBox "Bitte whlen Sie das Jahr aus!", vbOKOnly + vbCritical, "Fehler"
                Me.Jahresauswahl.SetFocus
                Exit Sub
            End If
        Case 22                 'Preise: Kategorie/Kalender
            'keine weiteren Eingaben erforderlich
            
            'Abfrage hier einbauen, damit danach(!) die Warte-Meldung angezeigt wird
            BerichteFilter = ""
            'Abfrage, ob ALLE Preise gelistet werden sollen, oder gefiltert entsprechend den Einstellungen
            If MsgBox("Bitte whlen Sie:" & vbNewLine & vbNewLine & "[Ja] = Es werden nur die Preise aufgelistet, die gem Ihren Einstellungen" _
                & " beim Rechnungs- / Kalkulationslauf bercksichtigt werden." & vbNewLine & vbNewLine _
                & "[Nein] = Es werden alle hinterlegte Preise je Kategorie / Kalender aufgelistet.", vbQuestion + vbYesNo + vbDefaultButton1, "Frage...") = vbYes Then
                    If RePreisJeKalender = True Then
                        BerichteFilter = "([lfd_Nr_Kalender]<>0)"
                    Else
                        BerichteFilter = "([lfd_Nr_Kalender]=0)"
                    End If
                    If RePreisJeKategorie = True Then
                        BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]<>" & SatzKategorieDummy & ")"
                    Else
                        BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
                    End If
            End If
            'und kundenspezifische Preise ausklammern (->nur Preise mit "(Ohne Kontakt)")
            If Len(BerichteFilter) = 0 Then
                BerichteFilter = "[lfd_Nr_Kunde]=" & SatzKontaktDummy
            Else
                BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
            End If
        Case 23                 'Preise: Kalender/Kategorie
            'keine weiteren Eingaben erforderlich
            
            'Abfrage hier einbauen, damit danach(!) die Warte-Meldung angezeigt wird
            BerichteFilter = ""
            'Abfrage, ob ALLE Preise gelistet werden sollen, oder gefiltert entsprechend den Einstellungen
            If MsgBox("Bitte whlen Sie:" & vbNewLine & vbNewLine & "[Ja] = Es werden nur die Preise aufgelistet, die gem Ihren Einstellungen" _
                & " beim Rechnungs- / Kalkulationslauf bercksichtigt werden." & vbNewLine & vbNewLine _
                & "[Nein] = Es werden alle hinterlegte Preise je Kalender / Kategorie aufgelistet.", vbQuestion + vbYesNo + vbDefaultButton1, "Frage...") = vbYes Then
                    If RePreisJeKalender = True Then
                        BerichteFilter = "([lfd_Nr_Kalender]<>0)"
                    Else
                        BerichteFilter = "([lfd_Nr_Kalender]=0)"
                    End If
                    If RePreisJeKategorie = True Then
                        BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]<>" & SatzKategorieDummy & ")"
                    Else
                        BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
                    End If
            End If
            'und kundenspezifische Preise ausklammern (->nur Preise mit "(Ohne Kontakt)")
            If Len(BerichteFilter) = 0 Then
                BerichteFilter = "[lfd_Nr_Kunde]=" & SatzKontaktDummy
            Else
                BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
            End If
            
        Case Else               'unbekannte Auswertungsnummer
            Exit Sub
    End Select
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln

    
    'je nach Bericht: Bericht aufrufen
    BerichteUeberschrift = ""
    '   BerichteFilter = "" nach oben verlegt, u.a. wegen Bericht 22
    BerichteJahreswahl = ""
    
    Select Case Me.Suchfeld.Value
        Case 1                  'Rechnungsbuch
            'Formular anzeigen
            BerichteUeberschrift = "Rechnungsbuch " & Me.Jahresauswahl.Value
            BerichteFilter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Rechnungsbuch_Hauptformular", acPreview
 '           Reports.Item("Rechnungsbuch_Hauptformular").Filter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
 '           Reports.Item("Rechnungsbuch_Hauptformular").Controls.Item("Ueberschrift").Caption = "Rechnungsbuch " & Me.Jahresauswahl.Value
        Case 2                  'Rechnungssummen nach Kunden
            'Formular anzeigen
            BerichteUeberschrift = "Rechnungssummen nach Kunden fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Rechnungsbuch_Kundenuebersicht", acPreview
 '           Reports.Item("Rechnungsbuch_Kundenuebersicht").Filter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
 '           Reports.Item("Rechnungsbuch_Kundenuebersicht").Controls.Item("Ueberschrift").Caption = "Rechnungssummen nach Kunden fr " & Me.Jahresauswahl.Value
        Case 3                  'Terminliste eines Kunden
            'Formular anzeigen
            BerichteUeberschrift = Me.Jahresauswahl.Value
            BerichteFilter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
            BerichteJahreswahl = Me.Jahresauswahl.Value
            DoCmd.OpenReport "Kunden_Termine_Hauptformular", acPreview
            'Formular und Unterformular auf Kunde und Jahr filtern
 '           Reports.Item("Kunden_Termine_Hauptformular").Filter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
 '           Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("Ueberschrift").Caption = Me.Jahresauswahl.Value
 '           Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("Jahresfilter").Caption = Me.Jahresauswahl.Value
 '           Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("km_Text").Caption = km_RechText
 '           Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("km_Einheit").Caption = km_TabellenKuerzel
 '           If km_Erfassung = False Then
 '               Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("km_Verwendung").Caption = "0"
 '           Else
 '               Reports.Item("Kunden_Termine_Hauptformular").Controls.Item("km_Verwendung").Caption = "1"
 '           End If

        Case 4                  'Rechnungsliste eines Kunden
            'Formular anzeigen
            BerichteUeberschrift = Me.Jahresauswahl.Value
            BerichteFilter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
            BerichteJahreswahl = Me.Jahresauswahl.Value
            DoCmd.OpenReport "Kunden_Rechnungen_Hauptformular", acPreview
            'Formular und Unterformular auf Kunde und Jahr filtern
 '           Reports.Item("Kunden_Rechnungen_Hauptformular").Filter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
 '           Reports.Item("Kunden_Rechnungen_Hauptformular").Controls.Item("Ueberschrift").Caption = Me.Jahresauswahl.Value
 '           Reports.Item("Kunden_Rechnungen_Hauptformular").Controls.Item("Jahresfilter").Caption = Me.Jahresauswahl.Value
        Case 5                  'Aktualisierungen
            'Formular anzeigen
            BerichteUeberschrift = "Aktualisierungen fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Aktualisierungen", acPreview
            'Formular Jahr filtern
 '           Reports.Item("Aktualisierungen").Filter = "[Jahr]=" & Me.Jahresauswahl.Value
 '           Reports.Item("Aktualisierungen").Controls.Item("Ueberschrift").Caption = "Aktualisierungen fr " & Me.Jahresauswahl.Value
        Case 6                  'Gebhrenliste eines Kunden
            'Formular anzeigen
            BerichteFilter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
            DoCmd.OpenReport "Kunden_Gebuehren_Hauptformular", acPreview
            'Formular und Unterformular auf Kundefiltern
 '           Reports.Item("Kunden_Gebuehren_Hauptformular").Filter = "[lfd_Nr]=" & Me.Kunden_direkt.Value
            'Reports.Item("Kunden_Gebuehren_Hauptformular").Controls.Item("Ueberschrift").Caption = Me.Jahresauswahl.Value
            'Reports.Item("Kunden_Gebuehren_Hauptformular").Controls.Item("Jahresfilter").Caption = Me.Jahresauswahl.Value
            
 ' >>>>> RICHTIGE Tabelle ffnen
 '           'Gebhrentabelle ffnen
 '           Set dbs = CurrentDb
 '           Set rst = Me.Gebuehren.Form.RecordsetClone
 '           'wenn kein Datensatz vorhanden, dann Hinweis auf dem Bericht anzeigen...
 '           If (rst.RecordCount = 0) Then
 '               Reports.Item("Kunden_Gebuehren_Hauptformular").Controls.Item("HinweisKeineGebuehr").Caption = "Keine individuellen Preise vorhanden."
 '           End If
 '           'Tabelle schliessen
 '           rst.Close
 '           Set dbs = Nothing
        Case 7                  'Umsatzverteilung
            'Formular anzeigen
            BerichteUeberschrift = "Umsatzverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KundenMitHoechstemUmsatz", acPreview
            'Reports.Item("Statistik_KundenMitHoechstemUmsatz").Filter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_KundenMitHoechstemUmsatz").Controls.Item("Ueberschrift").Caption = "Umsatzverteilung fr " & Me.Jahresauswahl.Value
        Case 8                  'Zeitverteilung
            'Formular anzeigen
            BerichteUeberschrift = "Zeitverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KundenMitHoechsterZeit", acPreview
            'Reports.Item("Statistik_KundenMitHoechsterZeit").Filter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_KundenMitHoechsterZeit").Controls.Item("Ueberschrift").Caption = "Zeitverteilung fr " & Me.Jahresauswahl.Value
        Case 9                  'Umsatzverteilung mit Zeitaufwand
            'Formular anzeigen
            BerichteUeberschrift = "Umsatzverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            DoCmd.OpenReport "Statistik_KundenHoechstemUmsatzUndZeit", acPreview
            'Reports.Item("Statistik_KundenHoechstemUmsatzUndZeit").Filter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            'Reports.Item("Statistik_KundenHoechstemUmsatzUndZeit").Controls.Item("Ueberschrift").Caption = "Umsatzverteilung fr " & Me.Jahresauswahl.Value
        Case 10                 'Zeitverteilung mit Umsatzanteil
            'Formular anzeigen
            BerichteUeberschrift = "Zeitverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            DoCmd.OpenReport "Statistik_KundenMeistenZeitUndUmsatz", acPreview
            'Reports.Item("Statistik_KundenMeistenZeitUndUmsatz").Filter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            'Reports.Item("Statistik_KundenMeistenZeitUndUmsatz").Controls.Item("Ueberschrift").Caption = "Zeitverteilung fr " & Me.Jahresauswahl.Value
        Case 11                 'Erfolgsverteilung
            'internen Stundensatz in den SQL-Text der Abfrage einbauen...
            strAbfrage = "SELECT DISTINCTROW Kunden.Name1, Kunden.Name2, Kunden.Ort, " _
                        & "Abf_Rech_SuNettoKundeJahr.Re_Jahr, Abf_Rech_SuNettoKundeJahr.NettoBerechnet, " _
                        & "Abf_Term_SuDauerKundeJahr.S_Jahr, Abf_Term_SuDauerKundeJahr.SummeVonDauer, " _
                        & "Nz([SummeVonDauer])*1 AS DauerBerechnet, ([DauerBerechnet]/60)*("
            strAbfrage = strAbfrage & Fix(InternerStundenSatz) & "."                                    'Stellen vor dem Komma und Dezimalpunkt
            strAbfrage = strAbfrage & Right(Format((InternerStundenSatz * 10000), "0000000000"), 4)     'die vier Stellen nach dem Komma
            strAbfrage = strAbfrage _
                        & ") AS InterneKosten, [NettoBerechnet]-[InterneKosten] AS GewinnVerlust " _
                        & "FROM (Kunden LEFT JOIN Abf_Rech_SuNettoKundeJahr ON Kunden.lfd_Nr = " _
                        & "Abf_Rech_SuNettoKundeJahr.lfd_Nr_Kunde) LEFT JOIN Abf_Term_SuDauerKundeJahr ON " _
                        & "Kunden.lfd_Nr = Abf_Term_SuDauerKundeJahr.lfd_Nr_Kunde " _
                        & "GROUP BY Kunden.Name1, Kunden.Name2, Kunden.Ort, Abf_Rech_SuNettoKundeJahr.Re_Jahr, " _
                        & "Abf_Rech_SuNettoKundeJahr.NettoBerechnet, Abf_Term_SuDauerKundeJahr.S_Jahr, " _
                        & "Abf_Term_SuDauerKundeJahr.SummeVonDauer;"
            '...und Abfrage neu erstellen
            dbs.QueryDefs.Refresh
            On Error Resume Next                        'Fehlermeldung bei fehlender Abfrage ignorieren
            dbs.QueryDefs.Delete "Abf_Rentabilitaet"
            Set qdf = dbs.CreateQueryDef("Abf_Rentabilitaet", strAbfrage)
            dbs.QueryDefs.Refresh
            On Error GoTo Err_START_Button_Click        'Fehlerbehandlung wieder einschalten
            
            'Formular anzeigen
            BerichteUeberschrift = "Erfolgsverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            DoCmd.OpenReport "Statistik_Erfolgsverteilung", acPreview
            'Reports.Item("Statistik_Erfolgsverteilung").Filter = "([Re_Jahr]=" & Me.Jahresauswahl.Value & ") AND ([S_Jahr]=" & Me.Jahresauswahl.Value & ")"
            'Reports.Item("Statistik_Erfolgsverteilung").Controls.Item("Ueberschrift").Caption = "Erfolgsverteilung fr " & Me.Jahresauswahl.Value
        Case 12                 'Rechnungslufe
            'Formular anzeigen
            BerichteUeberschrift = "Rechnungslufe fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Rechnungslaeufe", acPreview
            'Reports.Item("Rechnungslaeufe").Filter = "[Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Rechnungslaeufe").Controls.Item("Ueberschrift").Caption = "Rechnungslufe fr " & Me.Jahresauswahl.Value
        Case 13                 'Datenbankzuordnungen
            'Formular anzeigen
            DoCmd.OpenReport "Datenbankzuordnungen", acPreview
        Case 14                 'Versionshistorie
            'Formular anzeigen
            DoCmd.OpenReport "Versionshistorie", acPreview
        Case 15                 'Reisekilometer
            'Formular anzeigen
            BerichteUeberschrift = km_RechText & " fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KundenMitMeistenKm", acPreview
 '           Reports.Item("Statistik_KundenMitMeistenKm").Filter = "[S_Jahr]=" & Me.Jahresauswahl.Value
 '           Reports.Item("Statistik_KundenMitMeistenKm").Controls.Item("Ueberschrift").Caption = km_RechText & " fr " & Me.Jahresauswahl.Value
 '           Reports.Item("Statistik_KundenMitMeistenKm").Controls.Item("km_Text").Caption = km_RechText
 '           Reports.Item("Statistik_KundenMitMeistenKm").Controls.Item("km_Einheit").Caption = km_TabellenKuerzel
        Case 16                 'Zeitverteilung mit Reisekilometer
            'Formular anzeigen
            BerichteUeberschrift = "Zeitverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KundenMeistenZeitUndKm", acPreview
            'Reports.Item("Statistik_KundenMeistenZeitUndKm").Filter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_KundenMeistenZeitUndKm").Controls.Item("Ueberschrift").Caption = "Zeitverteilung fr " & Me.Jahresauswahl.Value
            Reports.Item("Statistik_KundenMeistenZeitUndKm").Controls.Item("km_Text").Caption = km_RechText
            Reports.Item("Statistik_KundenMeistenZeitUndKm").Controls.Item("km_Einheit").Caption = km_TabellenKuerzel
        Case 17                 'Zeitverteilung im Jahr
            'Formular anzeigen
            BerichteUeberschrift = "Zeitverteilung in " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_ZeitverteilungImJahr", acPreview
            'Reports.Item("Statistik_ZeitverteilungImJahr").Filter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_ZeitverteilungImJahr").Controls.Item("Ueberschrift").Caption = "Zeitverteilung in " & Me.Jahresauswahl.Value
        Case 18                 'Umsatzverteilung im Jahr
            'Formular anzeigen
            BerichteUeberschrift = "Umsatzverteilung in " & Me.Jahresauswahl.Value
            BerichteFilter = "[Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_UmsatzverteilungImJahr", acPreview
            'Reports.Item("Statistik_UmsatzverteilungImJahr").Filter = "[Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_UmsatzverteilungImJahr").Controls.Item("Ueberschrift").Caption = "Umsatzverteilung in " & Me.Jahresauswahl.Value
        Case 19                 'Kategorieverteilung
            'Formular anzeigen
            BerichteUeberschrift = "Kategorieverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_Kategorieverteilung", acPreview
            'Reports.Item("Statistik_Kategorieverteilung").Filter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            'Reports.Item("Statistik_Kategorieverteilung").Controls.Item("Ueberschrift").Caption = "Kategorieverteilung fr " & Me.Jahresauswahl.Value
        Case 20                 'Kategorien: Kalkulationsverteilung je Jahr
            'Formular anzeigen
            BerichteUeberschrift = "Kalkulationsverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KategorienKalkulationJeJahr", acPreview
        Case 21                 'Kategorien: Kalkulationsverteilung mit Zeitanteil
            'Formular anzeigen
            BerichteUeberschrift = "Kalkulationsverteilung fr " & Me.Jahresauswahl.Value
            BerichteFilter = "[S_Jahr]=" & Me.Jahresauswahl.Value
            DoCmd.OpenReport "Statistik_KategorienKalkulationUndZeit", acPreview
        Case 22                 'Preise: Kategorie/Kalender
            'Formular anzeigen
            BerichteUeberschrift = "Preise (Kategorie/Kalender)"
            'BerichteFilter wird weiter oben abgefragt und gesetzt,
            '  damit die Warte-Meldung die Bentutzereingabe nicht strt
            DoCmd.OpenReport "Preise_KategorieKalender", acPreview
        Case 23                 'Preise: Kalender/Kategorie
            'Formular anzeigen
            BerichteUeberschrift = "Preise (Kalender/Kategorie)"
            'BerichteFilter wird weiter oben abgefragt und gesetzt,
            '  damit die Warte-Meldung die Bentutzereingabe nicht strt
            DoCmd.OpenReport "Preise_KalenderKategorie", acPreview
            
    End Select


    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow



Exit_START_Button_Click:
    Exit Sub

Err_START_Button_Click:
    MsgBox err.Description
    Resume Exit_START_Button_Click

End Sub

Private Sub Suchfeld_AfterUpdate()
    Dim dbs As Database
    Dim rst As Recordset
    
    ' Den mit dem Steuerelement bereinstimmenden Datensatz suchen.
    On Error Resume Next                            'falls Auswertungstabelle leer ist
    Me.RecordsetClone.FindFirst "[lfd_Nr] = " & Me![Suchfeld]
    Me.Bookmark = Me.RecordsetClone.Bookmark

    'Jahreszahl sicherheitshalber lschen
    Me.Jahresauswahl.DefaultValue = ""

    'alle Eingabefelder sperren
    Me.Jahresauswahl.Enabled = False
    Me.Kunden_alle.Enabled = False
    Me.Kunden_nur.Enabled = False
    Me.Kundenauswahl.Enabled = False
    Me.Kunden_direkt.Enabled = False
    Me.START_Button.Enabled = False
    
    'bentigte Eingabefelder freigeben
    Select Case Me.Suchfeld.Value
        Case 1, 2, 7, 9, 10, 11, 12, 18
            '  1 = Rechnungsbuch
            '  2 = Rechnungssummen nach Kunden
            '  7 = Umsatzverteilung
            '  9 = Umsatzverteilung mit Zeitaufwand
            ' 10 = Zeitverteilung mit Umsatzanteil
            ' 11 = Erfolgsverteilung
            ' 12 = Rechnungslufe
            ' 18 = Umsatzverteilung im Jahr
            
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Rech_SummeJahr].[Re_Jahr] FROM [Abf_Rech_SummeJahr] ORDER BY  [Abf_Rech_SummeJahr].[Re_Jahr] DESC;"
            
        Case 3                  'Terminliste eines Kunden
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Term_SuDauerJahr].[S_Jahr] FROM [Abf_Term_SuDauerJahr] ORDER BY  [Abf_Term_SuDauerJahr].[S_Jahr] DESC;"
            Me.Kunden_direkt.Enabled = True
            
        Case 4                  'Rechnungsliste eines Kunden
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Rech_SummeJahr].[Re_Jahr] FROM [Abf_Rech_SummeJahr] ORDER BY  [Abf_Rech_SummeJahr].[Re_Jahr] DESC;"
            Me.Kunden_direkt.Enabled = True
            
        Case 5                  'Aktualisierungen
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_AktualisierungenJahr].[Jahr] FROM [Abf_AktualisierungenJahr] ORDER BY  [Abf_AktualisierungenJahr].[Jahr] DESC;"
            
        Case 6                  'Gebhrenliste eines Kunden
            Me.Kunden_direkt.Enabled = True
            
        Case 8, 17, 19, 20, 21      '  8 = Zeitverteilung
                                    ' 17 = Zeitverteilung im Jahr
                                    ' 19 = Kategorieverteilung
                                    ' 20 = Kategorien: Kalkulationsverteilung je Jahr
                                    ' 21 = Kategorien: Kalkulationsverteilung mit Zeitanteil
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Term_SuDauerJahr].[S_Jahr] FROM [Abf_Term_SuDauerJahr] ORDER BY  [Abf_Term_SuDauerJahr].[S_Jahr] DESC;"
        
        Case 13, 14             ' 13 = Datenbankzuordnungen
                                ' 14 = Versionshistorie
            'Keine weitere Auswahl erforderlich
            
        Case 15                 'Reisekilometer
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Km_SuKmJahr].[S_Jahr] FROM [Abf_Km_SuKmJahr] ORDER BY  [Abf_Km_SuKmJahr].[S_Jahr] DESC;"
        
        Case 16                 ' Zeitverteilung mit Reisekilometer
            Me.Jahresauswahl.Enabled = True
            Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Km_SuKmJahr].[S_Jahr] FROM [Abf_Km_SuKmJahr] ORDER BY  [Abf_Km_SuKmJahr].[S_Jahr] DESC;"
        
    End Select
    
    'Jahresauswahl mit dem hchsten Jahr vorbelegen
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset(Me.Jahresauswahl.RowSource)
    If rst.RecordCount > 0 Then
        rst.MoveFirst
        Select Case Me.Suchfeld.Value
            Case 1, 2, 4, 7, 9, 10, 11, 12, 18
                '  1 = Rechnungsbuch
                '  2 = Rechnungssummen nach Kunden
                '  4 = Rechnungsliste eines Kunden
                '  7 = Umsatzverteilung
                '  9 = Umsatzverteilung mit Zeitaufwand
                ' 10 = Zeitverteilung mit Umsatzanteil
                ' 11 = Erfolgsverteilung
                ' 12 = Rechnungslufe
                ' 18 = Umsatzverteilung im Jahr
                Me.Jahresauswahl.DefaultValue = rst!Re_Jahr
            Case 3, 8, 15, 16, 17, 19, 20, 21
                '  3 = Terminliste eines Kunden
                '  8 = Zeitverteilung
                ' 15 = Reisekilometer
                ' 16 = Zeitverteilung mit Reisekilometer
                ' 17 = Zeitverteilung im Jahr
                ' 19 = Kategorieverteilung
                ' 20 = Kategorien: Kalkulationsverteilung je Jahr
                ' 21 = Kategorien: Kalkulationsverteilung mit Zeitanteil
                Me.Jahresauswahl.DefaultValue = rst!S_Jahr
            Case 5
                '  5 = Aktualisierungen
                Me.Jahresauswahl.DefaultValue = rst!Jahr
            Case 13, 14             ' 13 = Datenbankzuordnungen
                                    ' 14 = Versionshistorie
                'Keine weitere Auswahl erforderlich
        End Select
    End If
    rst.Close
    Set dbs = Nothing
    
    Me.START_Button.Enabled = True
    
End Sub
